<?php

$readlist = array();
global $readlist;

$id = findassetbyname($assetname);
if ($id <= 0)
{			
	//echo "] }\r\n";		
	return;
}

$ass = new Asset($id);
$props = $ass->GetProperties();
$foundprop = 0;

foreach($props as $p)
{
	if (strtolower($p->name) == $propertyname)
	{
		$foundprop = $p->id;
		break;
	}
}


if ($foundprop == 0)
{
	foreach($props as $p)
	{
		$parts = explode(' - ',$p->name);
		if (count($parts) > 1)
		{
			$newname = strtolower($parts[1].' '.$parts[0]);
			if ($newname == $propertyname)
			{
				$foundprop = $p->id;
				break;
			}
		}				
	}
}

$xaxis = $targ->xaxis;
$yaxis = $targ->yaxis;

if (strtolower($xaxis) == "time")
{
	if ($first == true)
		$first = false;
	else
		echo ','; 

	//OK - this is a standard scan.	
	$id = findassetbyname($assetname);
	if ($id <= 0)
	{		
		//echo "No Asset";
		echo "] }\r\n";		
		continue;
	}
	
	$readlist = array();
	
	$data = $ass->GetProperties();
	foreach($data as $d)
	{
		if ($d->id == $foundprop)
		{
			$readlist[] = $d;
			break;
		}
	}
	
	$ass->GetValues($readlist,TRUE);
	
	$node = "";
	//print_r($readlist[0]);
	if ((isset($readlist[0]->value['_dynamics'])) && ($readlist[0]->value['_dynamics'][0] == 'measurement'))
	{
		$node = "measurement";
	}
	if ((isset($readlist[0]->value['_dynamics'])) && ($readlist[0]->value['_dynamics'][0] == 'state'))
	{
		$node = "state";
	}
	if ((isset($readlist[0]->value['_dynamics'])) && ($readlist[0]->value['_dynamics'][0] == 'value'))
	{
		$node = "value";
	}
	
	if ($node == "")
	{
		echo 'Node?';
		echo "] }\r\n";		
		continue;
	}
	
	$sourceasset = $readlist[0]->origin;
	if ($readlist[0]->origintype == 'template')
	{
		$sourceasset = $id;
	}
	
	$measurement = $readlist[0]->id;
	
	$pointset = array();
	$v = array();			
	$v['node'] = $node;
	$v['property'] = $measurement;
	$v['asset'] = $sourceasset;
	$v['id'] = 1;
	$pointset[] = $v;
	
	$grain = -100;
				
	$start = gmdate('Y-m-d H:i:s', $stime->getTimestamp());
	$end = gmdate('Y-m-d H:i:s', $etime->getTimestamp());
	
	//print_r($pointset);
	//print_r($start);
	
	$res = GetBulkHistory($pointset,$start,$end,$grain,'continue',true,1);		
	if ($res === FALSE)
	{		
		//echo 'No Data!';
		$res = array();
	}
	
	//echo "Results: ";
	//print_r($res);
	
	$points = array();
	foreach($res as $r)
	{
		
		$p = array();
		$p[0] = DateTime::createFromFormat('Y-m-d H:i:s',$r[1])->getTimestamp();
		$p[1] = $r[2];	
		if ($p[1] == "^") $p[1] = 'null';		
		$points[] = $p;
	}
	
	$firstdp = true;
	
	foreach($points as $px)
	{
		if ($firstdp == true)
		{
			$firstdp = false;
			echo "\r\n";
		}
		else
			echo ",\r\n";
		
		if (trim($px[1]) == "^") $px[1] = "null";
		echo '      ['.$px[1].','.($px[0] * 1000).']';
	}
	?>			
		]
	}
	<?php
	return;
}

//Grab Relationship Name

include_once($installfolder.'/model/relationship.php');

$rels = Relationships::GetAllRelationships();
$relid = 0;
foreach($rels as $rx)
{
	if ($rx->name == $xaxis)
	{
		$relid = $rx->id;
		break;
	}
}

if ($relid == 0)
{
	//echo "] }\r\n";		
	return;
}

$alist = array();
$aset = array();
$pset = array();
$touched = array();
$scanpoints = array();
$propexample = FALSE;

$scanpoints[] = $id;

while(true)
{
	if (count($scanpoints) == 0) break;
	$active = $scanpoints[0];
	$scanpoints = array_slice($scanpoints,1);
	if (in_array($active,$touched)) continue;
	
	$touched[] = $active;
	
	$ast = new Asset($active);
	$prps = $ast->GetProperties();
	foreach($prps as $px)
	{
		if ($px->id == $foundprop)
		{
			$or = $px->origin;
			if ($px->origintype == 'template')
			{
				$or = $active;
			}
			if (!in_array($or,$alist))
			{
				$alist[] = $active;
				$aset[] = $ast;
				$pset[] = $px;
				$propexample = $px;
			}
			break;
		}
	}	
	
	if (isset($asset[$active]['relationships'][$relid]))
	{		
		foreach($asset[$active]['relationships'][$relid] as $r)
		{
			if ($r['upstream'] == false)
			{
				if (!in_array($r['target'],$touched))
				{
					if (!in_array($r['target'],$scanpoints))
					{
						$scanpoints[] = $r['target'];
					}
				}
			}
		}
	}
	else
	{
		//echo $ast->name.' dead ends on '.$relid;
		$ast->UpdateCache();
		//print_r($asset[$active]);
	}
}

//print_r($alist);
//exit;

$channelper = false;
$subs = array();

if (strtolower($yaxis) == "none")
{
	//OK, get the most recent current values along the relationship.
	if ($channelper == false) {
		$fancyname = $propname.' Profile From '.$ass->name ;
		if ($ass->ern != "")
		{
			$fancyname = $propname.' Profile From '.$ass->ern;
		}
	?>	{
		"target":"<?php echo $fancyname; ?>",
		"datapoints":[ <?php
	$indx = -1;
	
	$base = $stime->getTimestamp() * 1000;
	$peritem = (($etime->getTimestamp() * 1000) - $base) / (count($alist)-1);
	
	//echo 'Working...';

	//foreach($alist as $a)
	//{
		$indx = -1;
		$added = 0;
		
		//Get connected assets....
		$node = "measurement";
		if ($propexample->type == "ENUM")
		{
			$node = "value";
		}
		if ($propexample->type == "STATUS")
		{
			$node = "state";
		}
		
		$query = $db->query('SELECT assetid FROM datalinks WHERE profile=1 AND assetid IN ('.implode(',',$alist).') AND propertyid='.$foundprop);
		$touched = array();

		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{
			$px = clone $pset[0];
			$px->origin = $row['assetid'];			
			for($x=0;$x<count($alist);$x++)
			{
				if ($alist[$x] == $row['assetid'])
				{
					$px->value['_dynamics'][0] = $node;
					$subs[$x] = $px;
					$touched[] = $x;					
					//echo 'Pretouched '.$x;
				}
			}			
		}
		
		foreach($alist as $a)
		{
			$indx++;
			if (in_array($indx,$touched))
				continue;				
			
			$tmp = array();
			$tmp[] = $pset[$indx];
			$aset[$indx]->GetValues($tmp,TRUE);
			
			if (isset($tmp[0]->value['_dynamics']))
			{
				//Add to subscription request...
				$subs[$indx] = $tmp[0];
			}
			else
			{
			
				if ($indx > 0) echo ',';				
		
				echo '[ '.ExtractValue($tmp[0]).','.($base + ($peritem * $indx)).']';
				$added++;
			}
		}	
		
		if (count($subs) > 0)
		{
			$codelookup = array();
			$indexlookup = array();
			$dynamicdata = array();
			foreach($subs as $k => $v)
			{
				$orig = $v->origin;
				if ($v->origintype == "template") $orig = $aset[$k]->id;
				$s = $orig.':'.$v->id.':'.array_values($v->value['_dynamics'])[0];
				$dynamicdata[] = $s;
				$codelookup[$s] = $aset[$k];
				if (!isset($indexlookup[$s]))
					$indexlookup[$s] = $k;
			}
			
			//print_r($dynamicdata);
			//exit;
			$sampleprofile = 1;
			
			$dynset = implode(',',$dynamicdata);
				
			//Figure out the local consolidator port...
			$query = $db->query('SELECT reqport FROM profiles WHERE id='.$sampleprofile);

			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				$conport = $row['reqport'];
			}
		
			$url = "http://localhost:".$conport."/snapshot";
			$ch = curl_init(); 
			//echo 'Calling '.$url.' / '.$dynset;
			curl_setopt($ch, CURLOPT_URL, $url); 
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS,  'codes='.urlencode($dynset));
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			$output = curl_exec($ch); 
			curl_close($ch);    
			
			//Process the XML results
			//echo $output;
			//echo urlencode($dynset);
			$xml=simplexml_load_string($output);
			
			if (isset($xml->points[0]))
			{
				foreach($xml->points[0]->point as $pv)
				{
					//Assign Values
					$code = strtolower($pv->attributes()['code']);
					
					if ($added == true) echo ', ';
					$added = true;
					
					//echo $code.' - '.$indexlookup[$code];
					//print_r($indexlookup);
					
					if (is_numeric($pv->attributes()['value']))
						echo '[ '.$pv->attributes()['value'].','.($base + ($peritem * $indexlookup[$code])).']';
					else
						echo '[ '.$pv->attributes()['value'].','.($base + ($peritem * $indexlookup[$code])).']';
					
					$indexlookup[$code] = $indexlookup[$code] + 1;
					
				}		
			}
		}
	//}
	?> ] }<?php
	}
	else
	{
		$indx = -1;
		$added = 0;
		
		//Get connected assets....
		$node = "measurement";
		if ($propexample->type == "ENUM")
		{
			$node = "value";
		}
		if ($propexample->type == "STATUS")
		{
			$node = "state";
		}
		
		$query = $db->query('SELECT assetid FROM datalinks WHERE profile=1 AND assetid IN ('.implode(',',$alist).') AND propertyid='.$foundprop);
		$touched = array();

		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{
			$px = clone $pset[0];
			$px->origin = $row['assetid'];			
			for($x=0;$x<count($alist);$x++)
			{
				if ($alist[$x] == $row['assetid'])
				{
					$px->value['_dynamics'][0] = $node;
					$subs[$x] = $px;
					$touched[] = $x;					
					//echo 'Pretouched '.$x;
				}
			}			
		}
		
		foreach($alist as $a)
		{
			$indx++;
			if (in_array($indx,$touched))
				continue;				
			
			$tmp = array();
			$tmp[] = $pset[$indx];
			$aset[$indx]->GetValues($tmp,TRUE);
			
			if (isset($tmp[0]->value['_dynamics']))
			{
				//Add to subscription request...
				$subs[$indx] = $tmp[0];
			}
			else
			{
			
				if ($indx > 0) echo ',';
				$nm = $aset[$indx]->ern;
				if ($nm == "") $nm = $aset[$indx]->name;
		?>	{
			"target":"<?php echo $nm; ?>",
			"datapoints": <?php
					
	
				echo '[ [ '.ExtractValue($tmp[0]).','.($etime->getTimestamp() * 1000).'] ] }';
				$added++;
			}
		}	
		
		if (count($subs) > 0)
		{
			$codelookup = array();
			$dynamicdata = array();
			foreach($subs as $k => $v)
			{
				$s = $aset[$k]->id.':'.$v->id.':'.array_values($v->value['_dynamics'])[0];
				$dynamicdata[] = $s;
				$codelookup[$s] = $aset[$k];
			}
			
			//print_r($dynamicdata);
			
			$sampleprofile = 1;
			
			$dynset = implode(',',$dynamicdata);
				
			//Figure out the local consolidator port...
			$query = $db->query('SELECT reqport FROM profiles WHERE id='.$sampleprofile);

			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				$conport = $row['reqport'];
			}
		
			$url = "http://localhost:".$conport."/snapshot";
			$ch = curl_init(); 
			//echo 'Calling '.$url.' / '.$dynset;
			curl_setopt($ch, CURLOPT_URL, $url); 
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS,  'codes='.urlencode($dynset));
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			$output = curl_exec($ch); 
			curl_close($ch);    
			
			//Process the XML results
			//echo $output;
			$xml=simplexml_load_string($output);
			
			if (isset($xml->points[0]))
			{
				foreach($xml->points[0]->point as $pv)
				{
					//Assign Values
					$code = strtolower($pv->attributes()['code']);
					
					if ($added == true) echo ', ';
					$added = true;
					$nm = $codelookup[$code]->ern;
					if ($nm == "") $nm = $codelookup[$code]->name;
					?>	{
			"target":"<?php echo $nm; ?>",
			"datapoints": <?php
					
					if (is_numeric($pv->attributes()['value']))
						echo '[ [ '.$pv->attributes()['value'].','.($etime->getTimestamp() * 1000).'] ] }';
					else
						echo '[ [ '.$pv->attributes()['value'].','.($etime->getTimestamp() * 1000).'] ] }';
					
				}		
			}
		}
		
	}
	return;
}

if (strtolower($yaxis) == "time")
{
	//Time to get history across the relationship
	$pointset = array();
	
	$indx = -1;
	foreach($aset as $assx)
	{
		$indx++;
		$readlist = array();
		$readlist[] = $pset[$indx];
		
		$values = $assx->GetValues($readlist,TRUE);
			
		$node = "";
		//print_r($readlist[0]);
		if ((isset($readlist[0]->value['_dynamics'])) && ($readlist[0]->value['_dynamics'][0] == 'measurement'))
		{
			$node = "measurement";
		}
		if ((isset($readlist[0]->value['_dynamics'])) && ($readlist[0]->value['_dynamics'][0] == 'state'))
		{
			$node = "state";
		}
		if ((isset($readlist[0]->value['_dynamics'])) && ($readlist[0]->value['_dynamics'][0] == 'value'))
		{
			$node = "value";
		}
		$sourceasset = $readlist[0]->origin;
		if ($readlist[0]->origintype == 'template')
		{
			$sourceasset = $assx->id;
		}
		
		$measurement = $readlist[0]->id;
				
		$v = array();			
		$v['node'] = $node;
		$v['property'] = $measurement;
		$v['asset'] = $sourceasset;
		$v['id'] = $indx;
		$pointset[] = $v;
	}
	
	$grain = -100;
				
	$start = gmdate('Y-m-d H:i:s', $stime->getTimestamp());
	$end = gmdate('Y-m-d H:i:s', $etime->getTimestamp());
	
	$res = GetBulkHistory($pointset,$start,$end,$grain,'continue',true,1);		
	if ($res === FALSE)
	{				
		$res = array();
	}
	
	//print_r($res);
	
	$indx = -1;	
	
	foreach($alist as $a)
	{
		$indx++;
		if ($indx > 0) echo ',';
		$nm = $aset[$indx]->ern;
		if ($nm == "") $nm = $aset[$indx]->name;
	?>	{
		"target":"<?php echo $nm; ?>",
		"datapoints": <?php
				
		$tmp = array();
		$tmp[] = $pset[$indx];
		$aset[$indx]->GetValues($tmp);		
			
		$points = array();
		foreach($res as $r)
		{
			if ($r[0] != $indx) continue;
			$p = array();
			$p[0] = DateTime::createFromFormat('Y-m-d H:i:s',$r[1])->getTimestamp();
			$p[1] = $r[2];	
			if ($p[1] == "^") $p[1] = "null";
			$points[] = $p;
		}
		
		$firstdp = true;
		echo ' [ ';
		
		foreach($points as $px)
		{			
			if ($firstdp == true)
			{
				$firstdp = false;
				echo "\r\n";
			}
			else
				echo ",\r\n";
			
			echo '      ['.$px[1].','.($px[0] * 1000).']';
		}
				
		echo ' ] }';
	}	
	return;
}

$rels = Relationships::GetAllRelationships();
$yrelid = 0;
foreach($rels as $rx)
{
	if ($rx->name == $yaxis)
	{
		$yrelid = $rx->id;
		break;
	}
}

if ($yrelid == 0)
{
	//echo "] }\r\n";		
	continue;
}

$fullalist = array();
$yalist = array();
$yaset = array();
$ypset = array();

foreach($alist as $a)
{
	$fullalist[] = $a;
}



$xindex = -1;
foreach($alist as $a)
{	
	$xindex++;
	$touched = array();
	$scanpoints = array();

	$scanpoints[] = $a;

	while(true)
	{
		if (count($scanpoints) == 0) break;
		$active = $scanpoints[0];
		$scanpoints = array_slice($scanpoints,1);
		if (in_array($active,$touched)) continue;
		
		$touched[] = $active;
		
		if (!isset($yalist[$xindex]))
		{
			$yalist[$xindex] = array();
			$yaset[$xindex] = array();
			$ypset[$xindex] = array();
		}
		
		$ast = new Asset($active);
		$prps = $ast->GetProperties();
		foreach($prps as $px)
		{
			if ($px->id == $foundprop)
			{
				$or = $px->origin;
				if ($px->origintype == 'template')
				{
					$or = $active;
				}
				if (!in_array($or,$yalist[$xindex]))
				{
					$yalist[$xindex][] = $active;
					$yaset[$xindex][] = $ast;
					$ypset[$xindex][] = $px;
					if (!in_array($active,$fullalist))
						$fullalist[] = $active;
					//$propexample = $px;
				}
				break;
			}
		}	
		
		if (isset($asset[$active]['relationships'][$yrelid]))
		{
			foreach($asset[$active]['relationships'][$yrelid] as $r)
			{
				if ($r['upstream'] == false)
				{
					if (!in_array($r['target'],$touched))
					{
						if (!in_array($r['target'],$scanpoints))
						{
							$scanpoints[] = $r['target'];
						}
					}
				}
			
			}
		}
	}
}

$mxheight = -1;
foreach($yaset as $bb)
{
	$n = count($bb);
	if ($n > $mxheight)
	{
		$mxheight = $n;
	}
}

//Get connected assets....
$subs = array();
$node = "measurement";
if ($propexample->type == "ENUM")
{
	$node = "value";
}
if ($propexample->type == "STATUS")
{
	$node = "state";
}

$query = $db->query('SELECT assetid FROM datalinks WHERE profile=1 AND assetid IN ('.implode(',',$fullalist).') AND propertyid='.$foundprop);
$touched = array();

while($row = $query->fetch(PDO::FETCH_ASSOC)) 
{
	$px = clone $pset[0];
	$px->origin = $row['assetid'];			
	for($x=0;$x<count($fullalist);$x++)
	{
		if ($fullalist[$x] == $row['assetid'])
		{
			$px->value['_dynamics'][0] = $node;
			$subs[$px->origin] = $px;				
		}
	}			
}

if (count($subs) > 0)
{
	$codelookup = array();
	$dynamicdata = array();
	foreach($subs as $k => $v)
	{
		$s = $k.':'.$v->id.':'.array_values($v->value['_dynamics'])[0];
		$codelookup[$s] = $k;
		$dynamicdata[] = $s;		
	}
	
	//print_r($dynamicdata);
	//print_r($codelookup);
	
	$sampleprofile = 1;
	
	$dynset = implode(',',$dynamicdata);
		
	//Figure out the local consolidator port...
	$query = $db->query('SELECT reqport FROM profiles WHERE id='.$sampleprofile);

	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		$conport = $row['reqport'];
	}

	$url = "http://localhost:".$conport."/snapshot";
	$ch = curl_init(); 
	//echo 'Calling '.$url.' / '.$dynset;
	curl_setopt($ch, CURLOPT_URL, $url); 
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS,  'codes='.urlencode($dynset));
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	$output = curl_exec($ch); 
	curl_close($ch);    
	
	//Process the XML results
	//echo $output;
	$xml=simplexml_load_string($output);
	
	$values = array();		
	
	if (isset($xml->points[0]))
	{
		foreach($xml->points[0]->point as $pv)
		{
			//Assign Values
			$code = strtolower($pv->attributes()['code']);
			
			//if ($added == true) echo ', ';
			//$added = true;
			$id = $codelookup[$code];
			$values[$id] = $pv->attributes()['value'];				
		}		
	}
}

$base = $stime->getTimestamp() * 1000;
$peritem = (($etime->getTimestamp() * 1000) - $base) / $mxheight;

$xindx = -1;	
foreach($alist as $a)
{
	$xindx++;
	if ($xindx > 0) echo ',';
	$nm = $aset[$xindx]->ern;
	if ($nm == "") $nm = $aset[$xindx]->name;
?>	{
	"target":"<?php echo $nm; ?>",
	"datapoints": <?php
				
	$points = array();
	$yindx = -1;	
	
	
	
	foreach($yaset[$xindx] as $ya)
	{
		$yindx++;		
		
		//if ($r[0] != $indx) continue;
		
		//print_r($ypset[$xindx]);
		
		$tmp = array();
		$tmp = $ypset[$xindx][$yindx];
		
		//print_r($yaset[$xindx][$yindx]);
		//print_r($tmp);		
		//echo '------';
		//echo 'Checking For '.$ya->id;
		if (isset($values[$ya->id]))
		{
			$p = array();
			$p[0] = $base + ($peritem * $yindx);
			$p[1] = $values[$ya->id];		
			if ($p[1] == '^') $p[1] = 'null';
			$points[] = $p;
		}
		else
		{
			$yaset[$xindx][$yindx]->GetValues($tmp);	
			//print_r($tmp);				
			
			$p = array();
			$p[0] = $base + ($peritem * $yindx);
			$p[1] = ExtractValue($tmp);	
			if ($p[1] == "^") $p[1] = 'null';
			$points[] = $p;
		}
	}
	
	$firstdp = true;
	echo ' [ ';
	
	foreach($points as $px)
	{			
		if ($firstdp == true)
		{
			$firstdp = false;
			echo "\r\n";
		}
		else
			echo ",\r\n";
		//if ($px[1] == "^") $px[1] = 'null';
		echo '      ['.$px[1].','.($px[0]).']';
	}
			
	echo ' ] }';
}	
?>